/*********************************************************
Simple Action Component for MenuItem
Example submitted by Chua Chee Wee, Singapore

To use, compile.
Install into the Tool Palette using
1) Menu Components | Installed .Net Components
2) Select an Assembly: Action.dll
3) Then open the ActionDemo.bdsproj.
4) Start changing the Visible | Enabled | Text properties
   of the action1 item and see the associated component
   change its properties correspondingly!

Current issues:
1. Do not set ComponentLink to point to itself, i.e.:
if you have an Action named action1, do not set its
ComponentLink to action1, otherwise, you'll hang the IDE.

2. Do not point ComponentLink to a top level MenuItem.

**********************************************************/
using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using System.Reflection;

[assembly:
 AssemblyVersion("1.0.0.*"),
 AssemblyCompany(""),
 AssemblyTitle("MenuItem Action Demo"),
 AssemblyDescription("A simple custom control component"),
 AssemblyCopyright(""),
 AssemblyTrademark("Some example trademark"),
 AssemblyInformationalVersion(""),
 AssemblyProduct("")
]
// Browse the above attributes using Borland Reflection
namespace ActionControl
{
	/// <summary>
	/// Summary description for TAction.
	/// </summary>
	public class Action : System.ComponentModel.Component
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Action()
		{
			// This call is required by the Windows.Forms Designer.
			InitializeComponent();

			// TODO: Add any initialization after the InitForm call

		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose(bool disposing)
		{
			if (disposing)
			{
				if (components != null)
					components.Dispose();
			}
			base.Dispose(disposing);
		}

		#region Component Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			components = new System.ComponentModel.Container();
		}
		#endregion

		private System.ComponentModel.Component _ComponentLink=null;

		[Browsable(true),
		 Category("Misc"),
		 Description("Links to the specified component, allowing you to change it's Text, Visible or Enabled properties.")]
		public System.ComponentModel.Component ComponentLink {
			get {
				return _ComponentLink;
			}
			set {
				 if (value==this)
				   throw new Exception("ComponentLink cannot be set to itself!");
				 if (value is Action)
				   throw new Exception("ComponentLink cannot be another instance of the same type!");
				 if ((value!=null) && (!(value is MenuItem)))
				   throw new Exception("Unsupported component class: "+_ComponentLink.ToString());
				 _ComponentLink = value;
			}

		}

		[Browsable(true),
		 Category("Behaviour"),
		 Description("Change the ComponentLink's Enabled property to the specified value")]
		public bool Enabled {
			get {
				if (_ComponentLink is MenuItem)
					return ((MenuItem)_ComponentLink).Enabled;
				if (_ComponentLink != null)
					throw new Exception("Unsupported component class: "+_ComponentLink.ToString()); else
					return false;
			}
			set {
				if (_ComponentLink is MenuItem)
					((MenuItem)_ComponentLink).Enabled = value; else
				if (_ComponentLink != null)
					throw new Exception("Unsupported component class: "+_ComponentLink.ToString());
			}
		}

		[Browsable(true),
		 Category("Behaviour"),
		 Description("Change the ComponentLink's Checked property to the specified value")]
		public bool Checked {
			get {
				if (_ComponentLink is MenuItem)
					return ((MenuItem)_ComponentLink).Checked; else
				if (_ComponentLink != null)
					throw new Exception("Unsupported component class: "+_ComponentLink.ToString()); else
					return false;
			}
			set {
				if (_ComponentLink is MenuItem)
					((MenuItem)_ComponentLink).Checked = value; else
				if (_ComponentLink != null)
					throw new Exception("Unsupported component class: "+_ComponentLink.ToString());
			}
		}

		[Browsable(true),
		 Category("Appearance"),
		 Description("Change the ComponentLink's Text property to the specified value")]
		public string Text {
			get {
				 if (_ComponentLink is MenuItem)
					return ((MenuItem)_ComponentLink).Text; else
				 if (_ComponentLink != null)
					throw new Exception("Unsupported component class: "+_ComponentLink.ToString()); else
				 return "";
			}
			set {
				if (_ComponentLink is MenuItem)
					((MenuItem)_ComponentLink).Text = value; else
				if (_ComponentLink != null)
					throw new Exception("Unsupported component class: "+_ComponentLink.ToString());
			}
		}

		[Browsable(true),
		 Category("Appearance"),
		 Description("Change the ComponentLink's Visible property to the specified value")]
		public bool Visible {
			get {
				if (_ComponentLink is MenuItem)
					return ((MenuItem)_ComponentLink).Visible; else
				if (_ComponentLink != null)
					throw new Exception("Unsupported component class: "+_ComponentLink.ToString()); else
				return false;
			}
			set {
				 if (_ComponentLink is MenuItem)
					((MenuItem)_ComponentLink).Checked = value; else
				 if (_ComponentLink != null)
					throw new Exception("Unsupported component class: "+_ComponentLink.ToString());
			}
		}

		public override string ToString() {
			return "Setting ComponentLink to this is not supported!";
		}


	}
}
